#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

/******************************************************************************
Function Name  : main
Engineer       : r59709
Date           : 06/26/2009
Notes          : Sets up PWM channels 0 - 3 with different alignment and
               : polarity settings and 50% duty cycle. The user can observe
               : this by probing the channel pins.
******************************************************************************/
void main(void)
{
	EnableInterrupts;

  /*************************/
  PWMCAE = 0x0C; //Set center alignment for channels 0 - 3
  PWMPOL = 0x0A; //Set polarity for channels 0 - 3
  //The above register setting should match the following truth table  .
  //PWM0: Center Aligned=0, Polarity=0
  //PWM1: Center Aligned=0, Polarity=1
  //PWM2: Center Aligned=1, Polarity=0
  //PWM3: Center Aligned=1, Polarity=1
  //If possible, use a scope to observe all four PWM channels and
  //compare there format.
  /*************************/  
  
  PWMPER0 = 0xFF; //Set chan 0 period length to the maximum.
  PWMPER1 = 0xFF; //Set chan 1 period length to the maximum.
  PWMPER2 = 0xFF; //Set chan 2 period length to the maximum.
  PWMPER3 = 0xFF; //Set chan 3 period length to the maximum.

  PWMDTY0 = 0x80; //Set chan 0 duty cycle to half the maximum, 50%.
  PWMDTY1 = 0x80; //Set chan 1 duty cycle to half the maximum, 50%.
  PWMDTY2 = 0x80; //Set chan 2 duty cycle to half the maximum, 50%.
  PWMDTY3 = 0x80; //Set chan 3 duty cycle to half the maximum, 50%.

  PWME = 0x0F;    //Enable PWM channels 0 - 3
  
  for(;;);
  /* PLEASE MAKE SURE THAT YOU NEVER EXIT main(void) */
}
